% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_conformal_region.R
\name{hcp_conformal_region}
\alias{hcp_conformal_region}
\title{HCP conformal prediction region with repeated subsampling and repeated data splitting}
\usage{
hcp_conformal_region(
  dat,
  id_col,
  y_col = "Y",
  delta_col = "delta",
  x_cols,
  x_test,
  y_grid,
  alpha = 0.1,
  train_frac = 0.5,
  S = 5,
  B = 5,
  combine_B = c("cct", "mean"),
  combine_S = c("cct", "mean"),
  seed = NULL,
  return_details = FALSE,
  dens_method = c("rq", "qrf"),
  dens_taus = seq(0.05, 0.95, by = 0.02),
  dens_h = NULL,
  enforce_monotone = TRUE,
  tail_decay = TRUE,
  prop_method = c("logistic", "grf", "boosting"),
  prop_eps = 1e-06,
  ...
)
}
\arguments{
\item{dat}{A data.frame containing clustered observations. Must include \code{id_col}, \code{y_col},
\code{delta_col}, and all columns in \code{x_cols}.}

\item{id_col}{Subject/cluster identifier column name.}

\item{y_col}{Outcome column name.}

\item{delta_col}{Missingness indicator column name (1 observed, 0 missing).}

\item{x_cols}{Covariate column names used for both density estimation and missingness propensity.}

\item{x_test}{New covariate value(s). A numeric vector (treated as one row),
or a numeric matrix/data.frame with \code{nrow(x_test)=K} test points and
\code{ncol(x_test)=length(x_cols)} covariates.}

\item{y_grid}{Numeric vector of candidate \eqn{y} values at which to evaluate conformal \eqn{p}-values.}

\item{alpha}{Miscoverage level in (0,1). Region keeps \eqn{y} with \eqn{p(y)>\alpha}.}

\item{train_frac}{Fraction of subjects assigned to training in each split.}

\item{S}{Number of independent subject-level splits.}

\item{B}{Number of subsamples per split (one observation per subject per subsample).}

\item{combine_B}{Combine \eqn{p}-values across B subsamples: \code{"cct"} (default) or \code{"mean"}.}

\item{combine_S}{Combine \eqn{p}-values across S splits: \code{"cct"} (default) or \code{"mean"}.}

\item{seed}{Optional seed for reproducibility.}

\item{return_details}{Logical; if TRUE, also return split-level p-values and split metadata.}

\item{dens_method}{Density/quantile engine for \code{\link{fit_cond_density_quantile}}: \code{"rq"} or \code{"qrf"}.}

\item{dens_taus}{Quantile grid passed to \code{\link{fit_cond_density_quantile}}.}

\item{dens_h}{Bandwidth(s) passed to \code{\link{fit_cond_density_quantile}}.}

\item{enforce_monotone}{Passed to \code{\link{fit_cond_density_quantile}}.}

\item{tail_decay}{Passed to \code{\link{fit_cond_density_quantile}}.}

\item{prop_method}{Missingness propensity method for \code{\link{fit_missingness_propensity}}:
\code{"logistic"}, \code{"grf"}, or \code{"boosting"}.}

\item{prop_eps}{Clipping level for propensity predictions used by \code{\link{fit_missingness_propensity}}.}

\item{...}{Extra arguments passed to \code{\link{fit_missingness_propensity}}.}
}
\value{
If \code{return_details=FALSE} (default), a list with:
\describe{
\item{\code{region}}{Length-\code{K} list; \code{region[[k]]} is the subset of \code{y_grid} with \code{p_final[k, ] > alpha}.}
\item{\code{lo_hi}}{\code{K x 2} matrix with columns \code{c("lo","hi")} giving \code{min/max} of \code{region[[k]]} (NA if empty).}
\item{\code{p_final}}{\code{K x length(y_grid)} matrix of final p-values on \code{y_grid}.}
\item{\code{y_grid}}{The candidate grid used.}
}
If \code{return_details=TRUE}, also includes:
\describe{
\item{\code{p_split}}{An array with dimensions \code{c(S, K, length(y_grid))} of split-level p-values.}
\item{\code{split_meta}}{Train subject IDs for each split.}
}
}
\description{
Constructs a marginal conformal prediction region for a new covariate value
\eqn{x_{n+1}} under clustered data with missing outcomes, following the HCP framework:
\itemize{
\item \strong{(1) Model fitting.}
Fit a pooled conditional density model \eqn{\widehat\pi(y\mid x)} using
\code{\link{fit_cond_density_quantile}}, together with a marginal missingness
propensity model \eqn{\widehat p(x)=\mathbb{P}(\delta=1\mid x)} using
\code{\link{fit_missingness_propensity}}, both estimated on a subject-level
training split.

\item \strong{(2) Subsampled calibration.}
Repeatedly construct calibration sets by randomly drawing one observation
per subject from the calibration split.

\item \strong{(3) Weighted conformal scoring.}
Compute weighted conformal \eqn{p}-values over a candidate grid using the
nonconformity score \eqn{R(x,y)=-\widehat\pi(y\mid x)} and inverse-propensity
weights \eqn{w(x)=1/\widehat p(x)} under a MAR assumption.

\item \strong{(4) Aggregation.}
Aggregate dependent \eqn{p}-values across subsamples (B) and data splits (S)
using either the Cauchy combination test (CCT/ACAT) or the arithmetic mean.
}

The prediction region is returned as a subset of the supplied grid:
\deqn{\widehat C(x_{n+1};\alpha)=\{y\in\mathcal Y:\ p_{\text{final}}(y)>\alpha\}.}
}
\examples{
dat <- generate_clustered_mar(n = 200, m = 4, d = 2, target_missing = 0.30, seed = 1)
y_grid <- seq(-4, 4, length.out = 200)
x_test <- matrix(c(0.2, -1.0), nrow = 1); colnames(x_test) <- c("X1", "X2")

res <- hcp_conformal_region(
  dat, id_col = "id",
  y_col = "Y", delta_col = "delta",
  x_cols = c("X1", "X2"),
  x_test = x_test,
  y_grid = y_grid,
  alpha = 0.1,
  S = 2, B = 2,
  seed = 1
)

## interval endpoints on the y-grid (outer envelope)
c(lo = min(res$region[[1]]), hi = max(res$region[[1]]))

}
