% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_search.R
\name{plot_obj_val_order_statistic}
\alias{plot_obj_val_order_statistic}
\title{Plots an order statistic of the object value as a function of number of searches}
\usage{
plot_obj_val_order_statistic(
  obj,
  order_stat = 1,
  skip_every = 5,
  type = "o",
  ...
)
}
\arguments{
\item{obj}{The greedy search object object whose search history is to be visualized}

\item{order_stat}{The order statistic that you wish to plot. The default is \code{1} for the minimum.}

\item{skip_every}{Plot every nth point. This makes the plot generate much more quickly. The default is \code{5}.}

\item{type}{The type parameter for plot.}

\item{...}{Other arguments to be passed to the plot function.}
}
\value{
An array of order statistics as a list element
}
\description{
Plots an order statistic of the object value as a function of number of searches
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(20), nrow = 10)
ged = initGreedyExperimentalDesignObject(
  X,
  max_designs = 5,
  num_cores = 1,
  objective = "abs_sum_diff",
  start = TRUE,
  wait = TRUE,
  verbose = FALSE
)
plot_obj_val_order_statistic(ged, order_stat = 1, skip_every = 1)
}
}
\author{
Adam Kapelner
}
