% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domination.R
\name{nonDom}
\alias{nonDom}
\title{Generic non-domination computation}
\usage{
nonDom(points, ref = NULL, return.idx = FALSE)
}
\arguments{
\item{points}{matrix (one point per row) from which to extract non-dominated points, or,
if a reference \code{ref} is provided, non-dominated points with respect to  \code{ref}}

\item{ref}{matrix (one point per row) of reference (faster if they are already Pareto optimal)}

\item{return.idx}{if \code{TRUE}, return indices instead of points}
}
\value{
Non-dominated points from \code{points}, unless a \code{ref} is provided, in which case return points from \code{points} non-dominated by \code{ref}.
If \code{return.idx} is \code{TRUE}, only returns indices
}
\description{
Extract non-dominated points from a set, or with respect to a reference Pareto front
}
\details{
Use Kung non-domination sorting
}
\examples{
d <- 6
n <- 1000
n2 <- 1000

test <- matrix(runif(d * n), n)
ref <- matrix(runif(d * n), n)
indPF <- nonDom(ref, return.idx = TRUE)
all(nonDom(ref) == ref[indPF,])

system.time(res <- nonDom(test, ref[indPF,,drop = FALSE], return.idx = TRUE))
}
\references{
Kung, H. T., Luccio, F., & Preparata, F. P. (1975). On finding the maxima of a set of vectors. Journal of the ACM (JACM), 22(4), 469-476.
}
