% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{set.prior}
\alias{set.prior}
\title{Set BMA prior distribution for candidate shape parameters}
\usage{
set.prior(pen = NULL, numk = NULL, xi_lme = NULL, kpar = NULL, weight = NULL)
}
\arguments{
\item{pen}{Prior type: "norm" (normal) or "beta".}

\item{numk}{Number of candidate submodels.}

\item{xi_lme}{L-moment estimate of the shape parameter.}

\item{kpar}{Numeric vector of candidate xi values.}

\item{weight}{Weighting method name ("like", "gLd", or "med").}
}
\value{
A list containing:
\describe{
  \item{prior}{Numeric vector of prior probabilities (length numk)}
  \item{prior_mu_std}{(if pen="norm") Mean and std of the normal prior}
  \item{p_q_beta}{(if pen="beta") p and q parameters of the beta prior}
}
}
\description{
Internal function that sets up the prior distribution for
Bayesian Model Averaging (BMA) weights. Supports both normal and beta
priors, with hyperparameters adapted based on the weighting method and
L-moment estimate of xi.
}
\keyword{internal}
