% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev.R
\name{pk.norm.stnary}
\alias{pk.norm.stnary}
\alias{new_pf_norm}
\title{Normal preference function for shape parameter (stationary GEV)}
\usage{
pk.norm.stnary(para = NULL, mu = NULL, std = NULL)

new_pf_norm(para = NULL, mu = NULL, std = NULL)
}
\arguments{
\item{para}{A vector of GEV parameters.}

\item{mu}{Mean for normal distribution.}

\item{std}{Standard deviation for normal distribution.}
}
\value{
Preference function value (scalar).
}
\description{
Computes a normal distribution-based preference (penalty) function value
for the GEV shape parameter. The alias \code{new_pf_norm} is provided
for backward compatibility.
}
\examples{
# Normal preference with mean=-0.5, sd=0.2 at xi=-0.2
pk.norm.stnary(para = c(100, 20, -0.2), mu = -0.5, std = 0.2)

}
\references{
Shin, Y., Shin, Y., Park, J. & Park, J.-S. (2025). Generalized method of
L-moment estimation for stationary and nonstationary extreme value models.
arXiv preprint arXiv:2512.20385. \doi{10.48550/arXiv.2512.20385}
}
\seealso{
\code{\link{pk.beta.stnary}} for the beta penalty,
  \code{\link{MS_pk}} for the Martins-Stedinger penalty,
  \code{\link{glme.gev}} which uses these penalty functions.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
