% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{mle.gev.CD}
\alias{mle.gev.CD}
\title{Coles-Dixon Penalized MLE for GEV}
\usage{
mle.gev.CD(xdat, ntry = 10)
}
\arguments{
\item{xdat}{Numeric vector of data.}

\item{ntry}{Number of random starting points for optimization. Default is 10.}
}
\value{
A list containing:
  \item{mle}{MLE estimates (mu, sigma, xi) in Hosking style}
  \item{nllh}{Negative log-likelihood at the optimum}
  \item{conv}{Convergence status (0 = success)}
  \item{nsample}{Sample size}
}
\description{
Computes maximum penalized likelihood estimates for GEV parameters
using the Coles and Dixon (1999) prior penalty on the shape parameter.
}
\references{
Coles, S., & Dixon, M. (1999). Likelihood-based inference for extreme
value models. Extremes, 2(1), 5-23.
}
\keyword{internal}
