% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gareg_knots.R
\name{selectTau_uniform_exact}
\alias{selectTau_uniform_exact}
\title{Exact Uniform Sampler of Feasible Changepoints}
\usage{
selectTau_uniform_exact(N, m, minDist, lmax)
}
\arguments{
\item{N}{Integer series length.}

\item{m}{Integer number of changepoints to place.}

\item{minDist}{Integer minimum spacing between adjacent changepoints.}

\item{lmax}{Integer chromosome length.}
}
\value{
Integer vector length \code{lmax}:
  \code{c(m, tau_1, ..., tau_m, N+1, 0, 0, ...)}.
}
\description{
Samples \eqn{m} ordered changepoint indices uniformly from all feasible
configurations on \code{1:N} subject to a minimum spacing \code{minDist}.
Encodes the result as a chromosome for downstream GA operators.
}
\seealso{
\link{Popinitial_fixknots}, \link{mutation_fixknots}
}
