% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print_metrics_table}
\alias{print_metrics_table}
\title{Print per-class metrics and summary averages}
\usage{
print_metrics_table(
  results,
  digits = 4,
  include_macro = TRUE,
  include_weighted = TRUE,
  include_overall_accuracy = FALSE
)
}
\arguments{
\item{results}{List returned by \code{evaluate_single_las()} or \code{evaluate_two_las()}.}

\item{digits}{Integer. Number of decimal places to round numeric metrics.}

\item{include_macro}{Logical. If TRUE, include a "Macro avg" row.}

\item{include_weighted}{Logical. If TRUE, include a "Weighted avg" row.}

\item{include_overall_accuracy}{Logical. If TRUE, include an "Overall accuracy" row.}
}
\value{
Invisibly returns a \code{data.frame} with per-class metrics and optional summary rows.
}
\description{
Formats and prints a per-class metrics table from the output of
\code{\link{evaluate_single_las}} or \code{\link{evaluate_two_las}}.
The table includes per-class Support, Accuracy, Precision, Recall, and F1.
Optionally includes Macro and Weighted averages, and an Overall accuracy row.
}
\details{
\itemize{
\item \strong{Support}: number of true points in each class (row sum of confusion matrix).
\item \strong{Accuracy}: per-class accuracy here means \strong{Recall} (TP / (TP + FN)).
This is sometimes called \emph{producer's accuracy}.
\item \strong{Macro avg}: unweighted mean across classes (ignores class imbalance).
\item \strong{Weighted avg}: mean across classes weighted by Support (reflects imbalance).
\item \strong{Overall accuracy}: sum(diag(cm)) / sum(cm). This is optional because
it often duplicates the weighted recall/accuracy in multi-class settings.
}
}
\examples{
if (requireNamespace("lidR", quietly = TRUE)){
library(lidR)
las <-  readLAS(system.file("extdata", "las", "tree2.laz", package = "FuelDeep3D"))

res <- evaluate_single_las(
  las,
  truth_col = "label",
  pred_col  = "Classification",
  classes   = 0:2,
  class_names = c("0"="Ground","1"="Branch","2"="Leaves")
)

print_metrics_table(res, include_overall_accuracy = TRUE)
}

}
