% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.r
\name{predict}
\alias{predict}
\title{Predict fuel classes for a LAS/LAZ file using a pre-trained model}
\usage{
predict(
  cfg,
  mode = c("overwrite", "extra"),
  setup_env = FALSE,
  csf_args = list()
)
}
\arguments{
\item{cfg}{A configuration list created by \code{\link[=config]{config()}}.}

\item{mode}{Character. \code{"overwrite"} replaces the LAS \code{Classification} values with
model predictions; \code{"extra"} keeps original classification and adds a new attribute
for predictions (behavior depends on the Python writer).}

\item{setup_env}{Logical. If \code{TRUE}, calls \code{\link[=ensure_py_env]{ensure_py_env()}} (or your env setup helper)
before importing Python modules. Default: \code{FALSE}.}

\item{csf_args}{List of arguments passed to \code{\link[=add_ground_csf]{add_ground_csf()}} when \code{cfg$num_classes == 4}.}
}
\value{
A character string giving the path to the output LAS/LAZ file.
}
\description{
Runs inference on a LAS/LAZ file and writes a new LAS/LAZ with predicted fuel classes.
This function uses Python inference code shipped in \code{inst/extdata/python} and
loads a pre-trained PyTorch model via \code{reticulate}.
}
\details{
\itemize{
\item \strong{Model classes:} The shipped model is always loaded as a 3-class classifier
(\code{num_classes = 3} in the Python model). Predictions are produced for these 3 classes.

\item \strong{Output writing:} Predictions are written using the Python helper
\code{write_predictions_to_las()}.
\describe{
\item{\code{mode = "overwrite"}}{Replaces the LAS \code{Classification} field with predictions.}
\item{\code{mode = "extra"}}{Keeps the original \code{Classification} and writes predictions to an additional attribute (behavior is defined by the Python writer).}
}

\item \strong{Optional 4th class (ground):} If \code{cfg$num_classes == 4}, the function
post-processes the 3-class prediction LAS with \code{\link{add_ground_csf}} to detect ground
points and assign them to class \code{3}, producing a final 4-class LAS/LAZ.

\item \strong{Device selection:} Uses \code{cfg$device} if provided; otherwise selects
\code{"cuda"} when available and falls back to \code{"cpu"}.
}

Note: \code{setup_env} is accepted for API compatibility; if you want it to actually run the
environment setup, add a call such as \code{if (isTRUE(setup_env)) ensure_py_env()} before importing.
}
\examples{
\donttest{
if (requireNamespace("reticulate", quietly = TRUE) && 
    reticulate::py_module_available("torch")) {
    
library(FuelDeep3D)
library(reticulate)
use_condaenv("pointnext", required = TRUE)

cfg <- config(
  las_path     = system.file("extdata", "las", "tree2.laz", package = "FuelDeep3D"),
  
  # Option 2: write to a custom folder (edit this path)
  # out_pred_dir = "C:/Users/yourusername/Downloads/FuelDeep3D_predictions",
  out_pred_dir = file.path(tempdir(), "FuelDeep3D_predictions"),
  model_path   = system.file("extdata", "model", "best_model.pth", package = "FuelDeep3D"),
  num_classes  = 3
)

out_las <- predict(cfg, mode = "overwrite", setup_env = FALSE)
out_las
}
}
}
