% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{cvVAR_ENET}
\alias{cvVAR_ENET}
\title{Cross Validation for Elastic Net VAR Estimation}
\usage{
cvVAR_ENET(X, y, nvar, opt, needReproduce = FALSE)
}
\arguments{
\item{X}{A numeric matrix of predictors.}

\item{y}{Numeric vector of responses.}

\item{nvar}{Integer. The number of variables in the original VAR (number of columns in data).}

\item{opt}{List. A list of options including:
\itemize{
  \item \code{alpha}: The elastic net mixing parameter (default = 1).
  \item \code{nlambda}: Number of lambda values (default = 100).
  \item \code{type.measure}: Error measure for CV (default = "mse").
  \item \code{nfolds}: Number of folds for CV (default = 10).
  \item \code{parallel}: Logical. Whether to use parallel processing (default = FALSE).
  \item \code{ncores}: Number of cores for parallel processing (default = 1).
  \item \code{lambdas_list}: Optionally, a user-specified list of lambdas.
  \item \code{folds_ids}: Optionally, user-specified fold IDs for CV.
}}
}
\value{
An object of class \code{cv.glmnet} as returned by \code{glmnet::cv.glmnet}.
}
\description{
This internal function performs cross validation using elastic net (ENET)
estimation via the \code{glmnet} package. It supports parallel processing if requested.
}
\keyword{internal}
