% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mldfm.R
\name{mldfm}
\alias{mldfm}
\title{Multi-Level Dynamic Factor Model (MLDFM)}
\usage{
mldfm(
  data,
  blocks = 1,
  block_ind = NULL,
  global = 1,
  local = NULL,
  middle_layer = NULL,
  method = 0,
  tol = 1e-06,
  max_iter = 1000,
  center = TRUE,
  scale = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data}{A numeric matrix or data frame containing the time series data. Rows represent time points; columns represent observed variables.}

\item{blocks}{Integer. Number of blocks into which the data is divided.}

\item{block_ind}{Integer vector. End column indices for each block. Must be of length \code{blocks} and in increasing order.}

\item{global}{Integer. Number of global factors extracted from the entire dataset.}

\item{local}{Integer vector of length \code{blocks}. Specifies the number of local factors for each block.}

\item{middle_layer}{Named list. Each name is a string specifying a group of blocks (e.g., \code{"1-3"} or \code{"2-3"}), and each value is the number of factors to extract.}

\item{method}{Integer.  Method used to initialize the factors: \code{0} for Canonical Correlation Analysis (CCA), \code{1} for Principal Component Analysis (PCA).}

\item{tol}{Numeric. The tolerance level for the residual sum of squares (RSS) minimization process. Used as a convergence criterion.}

\item{max_iter}{Integer. The maximum number of iterations allowed for the RSS minimization process.}

\item{center}{Logical. If \code{TRUE} (default) center data columns.}

\item{scale}{Logical. If \code{TRUE} (default) scale data columns.}

\item{verbose}{Logical. If \code{TRUE} (default), print a summary of the mldfm.}
}
\value{
An object of class \code{mldfm}, which is a list containing:
\describe{
\item{factors}{Matrix of estimated factors.}
\item{loadings}{Matrix of factor loadings.}
\item{residuals}{Matrix of residuals.}
\item{fitted}{Matrix of fitted values.}
\item{method}{Initialization method used (CCA or PCA).}
\item{iterations}{Number of iterations before convergence.}
\item{factors_list}{List of estimated factors for each node.}
\item{call}{Function call.}
}
}
\description{
Estimates a Multi-Level Dynamic Factor Modelfrom time series data.
Supports both Single-bBlock (DFM) and hierarchical Multi-Block (MLDFM) structures with customizable factor extraction settings.
}
\examples{
mldfm_result <- mldfm(data = matrix(rnorm(100 * 5), 100, 5), blocks = 1, global = 2)

}
