% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fars_methods.R
\name{BIC.fars}
\alias{BIC.fars}
\title{BIC for a \code{fars} Object}
\usage{
\method{BIC}{fars}(object, ...)
}
\arguments{
\item{object}{An object of class \code{fars}.}

\item{...}{Additional arguments passed to the underlying \code{logLik()} method.}
}
\value{
A named numeric vector of BIC values, one per quantile level.
}
\description{
Computes BIC values for each quantile regression stored in a
\code{fars} object.

The number of observations used in the BIC penalty term is computed as
\code{periods - h}, reflecting the effective sample size of the
\code{h}-step-ahead dynamic quantile regression.
}
\examples{
fars_result <- compute_fars(
  dep_variable = rnorm(100),
  factors = matrix(rnorm(100 * 3), ncol = 3),
  h = 1
)
BIC(fars_result)
}
