% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fars_methods.R
\name{AIC.fars}
\alias{AIC.fars}
\title{AIC for a \code{fars} Object}
\usage{
\method{AIC}{fars}(object, ..., k = 2)
}
\arguments{
\item{object}{An object of class \code{fars}.}

\item{...}{Additional arguments passed to the underlying \code{AIC()} method.}

\item{k}{Numeric. Penalty per parameter (default 2), as in \code{stats::AIC()}.}
}
\value{
A named numeric vector of AIC values, one per quantile level.
}
\description{
Computes AIC values for each quantile regression stored in a
\code{fars} object.
}
\examples{
fars_result <- compute_fars(dep_variable = rnorm(100),
                            factors = matrix(rnorm(100 * 3), ncol = 3))
AIC(fars_result)
}
