% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinomialCIsByCategorical.R
\name{BinomialCIsByCategorical}
\alias{BinomialCIsByCategorical}
\title{Compute binomial probabilities over categorical variable levels}
\usage{
BinomialCIsByCategorical(
  DF,
  binVar,
  catVar,
  targetLevel,
  keepNA = "ifany",
  keepLevels = NULL,
  cLevel = 0.95
)
}
\arguments{
\item{DF}{A data frame containing \code{binVar} and \code{catVar}}

\item{binVar}{Binary variable for binomial probabilities}

\item{catVar}{Categorical variable over which binomial probabilities are computed}

\item{targetLevel}{Positive response level for \code{binVar}}

\item{keepNA}{Missing data handling option: \code{ifany} (the default), \code{no}, or \code{always}}

\item{keepLevels}{Optional subset of \code{catVar} levels to be used in the analysis; default \code{NULL} retains all levels}

\item{cLevel}{Confidence level for binomial probabilities (default 0.95)}
}
\value{
Data frame with one row for each \code{catVar} level in the analysis and these 6 columns:
\itemize{
\item \code{Level} the \code{catVar} level
\item \code{nWith} the number of records with \code{catVar} equal to \code{Level} and \code{binVar} equal to \code{targetLevel}
\item \code{nTotal} the total number of records with \code{catVar} equal to \code{Level}
\item \code{pEst} the estimated probability that \code{binVar} equals \code{targetLevel}
\item \code{loCI} the lower \code{cLevel} confidence limit for \code{pEst}
\item \code{upCI} the upper \code{cLevel} confidence limit for \code{pEst}
}
}
\description{
Compute binomial probabilities over categorical variable levels
}
\examples{
catVar <- c(rep("A", 100), rep("B", 100), rep("C", 100))
binVar <- c(rep(0,80),rep(1,20), rep(0,50),rep(1,50), rep(0,20),rep(1,80))
DF <- data.frame(catVar = catVar, binVar = binVar)
BinomialCIsByCategorical(DF, "binVar", "catVar", 1)
}
