% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_search.R
\name{symbolic_search_weighted}
\alias{symbolic_search_weighted}
\title{Weighted Symbolic Search}
\usage{
symbolic_search_weighted(
  target,
  predictors,
  weights,
  operators = NULL,
  constraints = NULL,
  n_runs = 3,
  complexity_penalty = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{target}{Numeric vector of target values (typically derivatives).}

\item{predictors}{Data frame of predictor variables.}

\item{weights}{Optional weight vector for weighted regression.}

\item{operators}{List specifying allowed operators:
\itemize{
\item binary: c("+", "-", "*", "/")
\item unary: c("exp", "log", "sqrt", "inv", "square")
\item custom: Custom function names (must be defined)
}}

\item{constraints}{List of constraints:
\itemize{
\item forced: Formula of terms that must appear
\item forbidden: Formula of terms that must not appear
\item max_complexity: Maximum expression complexity
}}

\item{n_runs}{Number of independent runs for robustness.}

\item{complexity_penalty}{Penalty per unit complexity.}

\item{verbose}{Print progress messages?}
}
\value{
A symbolic_search_result object
}
\description{
Performs symbolic search with weighted least squares.
}
