% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{export_results}
\alias{export_results}
\title{Export Results to Multiple Formats}
\usage{
export_results(
  results,
  output_dir,
  prefix = "empirical_dynamics",
  formats = c("rds", "csv")
)
}
\arguments{
\item{results}{Analysis results list.}

\item{output_dir}{Output directory (required, no default to comply with CRAN policy).}

\item{prefix}{File name prefix.}

\item{formats}{Vector of formats: "rds", "csv", "json", "latex".}
}
\value{
List of paths to created files.
}
\description{
Exports analysis results to various file formats.
}
\examples{
\donttest{
# Toy example
tmp_dir <- tempdir()
mock_results <- list(
  equation = stats::lm(mpg ~ wt, data = mtcars)
)

# Export
paths <- export_results(mock_results, output_dir = tmp_dir, formats = c("csv", "rds"))
}
}
