% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.feature.NN.R
\name{extractor.feature.NN}
\alias{extractor.feature.NN}
\title{Extracting features for the pre-trained Neural Networks for Determining the Number of Factors}
\usage{
extractor.feature.NN(
  response,
  model = "DNN",
  cor.type = "pearson",
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{response}{A required \code{N} × \code{I} matrix or data.frame consisting of the responses of \code{N} individuals
to \code{I} items.}

\item{model}{A character string indicating the model type. Possible values are \code{"DNN"} (default) or \code{"LSTM"}.}

\item{cor.type}{A character string indicating which correlation coefficient (or covariance) is
to be computed. One of \code{"pearson"} (default), \code{"kendall"}, or
\code{"spearman"}. @seealso \code{\link[stats]{cor}}.}

\item{use}{an optional character string giving a method for computing covariances in the presence of missing values. This
must be one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"}, \code{"na.or.complete"},
or \code{"pairwise.complete.obs"} (default). @seealso \code{\link[stats]{cor}}.}
}
\value{
A matrix (1×54 or 1×20) containing all the features for the DNN or LSTM.
}
\description{
This function is used to extract the features required by the pre-trained
Neural Networks (DNN or LSTM) for Determining the Number of Factors.  @seealso \code{\link[EFAfactors]{NN}}
}
\details{
For \code{"DNN"}, a total of two types of features (6 kinds, making up 54 features in total) will be extracted, and they are as follows:
1. Clustering-Based Features
\describe{
  \item{(1)}{Hierarchical clustering is performed with correlation coefficients as dissimilarity.
             The top 9 tree node heights are calculated, and all heights are divided by the maximum
             height. The heights from the 2nd to 9th nodes are used as features. @seealso \code{\link[EFAfactors]{EFAhclust}}}
  \item{(2)}{Hierarchical clustering with Euclidean distance as dissimilarity is performed. The top 9
             tree node heights are calculated, and all heights are divided by the maximum height. The
             heights from the 2nd to 9th nodes are used as features. @seealso \code{\link[EFAfactors]{EFAhclust}}}
  \item{(3)}{K-means clustering is applied with the number of clusters ranging from 1 to 9. The
             within-cluster sum of squares (WSS) for clusters 2 to 9 are divided by the WSS for a single
             cluster. @seealso \code{\link[EFAfactors]{EFAkmeans}}}
}
These three features are based on clustering algorithms. The purpose of division is to normalize the
data. These clustering metrics often contain information unrelated to the number of factors, such as
the number of items and the number of respondents, which can be avoided by normalization. The reason
for using the 2nd to 9th data is that only the top F-1 data are needed to determine the number of factors F.
The first data point is fixed at 1 after the division operations, so it is excluded. This approach
helps in model simplification.

2. Traditional Exploratory Factor Analysis Features (Eigenvalues)
\describe{
  \item{(4)}{The top 10 largest eigenvalues.}
  \item{(5)}{The ratio of the top 10 largest eigenvalues to the corresponding reference eigenvalues from
             Empirical Kaiser Criterion (EKC; Braeken & van Assen, 2017). @seealso \code{\link[EFAfactors]{EKC}}}
  \item{(6)}{The cumulative variance proportion of the top 10 largest eigenvalues.}
}
Only the top 10 elements are used to simplify the model.

For \code{"LSTM"}, a total of 2 types of features.
These features are as follows:
\describe{
  \item{(1)}{The top 10 largest eigenvalues.}
  \item{(2)}{The difference of the top 10 largest eigenvalues to the corresponding reference eigenvalues from
             arallel Analysis (PA). @seealso \code{\link[EFAfactors]{PA}}}
}
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
## Run extractor.feature.NN function.
features <- extractor.feature.NN(response, model="DNN")

print(features)

features <- extractor.feature.NN(response, model="LSTM")

print(features)
}

}
\seealso{
\code{\link[EFAfactors]{NN}}
}
\author{
Haijiang Qin <Haijiang133@outlook.com>
}
