% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.Hull}
\alias{print.CD}
\alias{print.PA}
\alias{print.EKC}
\alias{print.KGC}
\alias{print.EFAhclust}
\alias{print.NN}
\alias{print.FF}
\alias{print.CDF}
\alias{print.EFAvote}
\alias{print.EFAdata}
\alias{print.EFAscreet}
\alias{print.MAP}
\title{Print Methods}
\usage{
\method{print}{Hull}(x, ...)

\method{print}{CD}(x, ...)

\method{print}{PA}(x, ...)

\method{print}{EKC}(x, ...)

\method{print}{KGC}(x, ...)

\method{print}{EFAhclust}(x, ...)

\method{print}{NN}(x, ...)

\method{print}{FF}(x, ...)

\method{print}{CDF}(x, ...)

\method{print}{EFAvote}(x, ...)

\method{print}{EFAdata}(x, ...)

\method{print}{EFAscreet}(x, ...)

\method{print}{MAP}(x, ...)
}
\arguments{
\item{x}{An object of class \code{Hull}, \code{CD}, \code{PA}, \code{EKC},
\code{KGC}, \code{EFAkmeans}, \code{EFAhclust}, \code{NN}, \code{FF},
\code{CDF}, \code{EFAvote}, \code{EFAscreet}, \code{MAP},  or \code{STOC}.}

\item{...}{Additional arguments passed to the printing functions.}
}
\value{
None. Prints are produced as side effects.
}
\description{
These `print` methods for different results, including:
\itemize{
 \item Hull print for \code{\link[EFAfactors]{Hull}} results.
 \item Comparison Data print for \code{\link[EFAfactors]{CD}} results.
 \item Parallel Analysis print for \code{\link[EFAfactors]{PA}} results.
 \item Empirical Kaiser Criterion for \code{\link[EFAfactors]{EKC}} results.
 \item Kaiser-Guttman Criterion for \code{\link[EFAfactors]{KGC}} results.
 \item K-means print for \code{\link[EFAfactors]{EFAkmeans}} results.
 \item Hierarchical Clustering print for \code{\link[EFAfactors]{EFAhclust}} results.
 \item pre-trained Neural Networks print for \code{\link[EFAfactors]{NN}} results.
 \item Factor Forest for \code{\link[EFAfactors]{FF}} results.
 \item Comparison Data Forest print for \code{\link[EFAfactors]{CDF}} results.
 \item Voting Method print for \code{\link[EFAfactors]{EFAvote}} results.
 \item Scree print for \code{\link[EFAfactors]{EFAscreet}} results.
 \item Minimum Average Partial Test print for \code{\link[EFAfactors]{MAP}} results.
 \item Scree Test Optimal Coordinate print for \code{\link[EFAfactors]{STOC}} results.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{print(Hull)}: Print method for Hull objects

\item \code{print(CD)}: Print method for CD objects

\item \code{print(PA)}: Print method for PA objects

\item \code{print(EKC)}: Print method for EKC objects

\item \code{print(KGC)}: Print method for KGC objects

\item \code{print(EFAhclust)}: Print method for EFAhclust objects

\item \code{print(NN)}: Print method for NN objects

\item \code{print(FF)}: Print method for FF objects

\item \code{print(CDF)}: Print method for CDF objects

\item \code{print(EFAvote)}: Print method for EFAvote objects

\item \code{print(EFAdata)}: Print method for EFAdata objects

\item \code{print(EFAscreet)}: Print method for EFAscreet objects

\item \code{print(MAP)}: Print method for MAP objects

}}
\seealso{
\code{\link[EFAfactors]{Hull}}, \code{\link[EFAfactors]{CD}}, \code{\link[EFAfactors]{PA}},
         \code{\link[EFAfactors]{EKC}}, \code{\link[EFAfactors]{KGC}}, \code{\link[EFAfactors]{EFAkmeans}},
         \code{\link[EFAfactors]{EFAhclust}}, \code{\link[EFAfactors]{NN}}, \code{\link[EFAfactors]{FF}},
         \code{\link[EFAfactors]{CDF}}, \code{\link[EFAfactors]{EFAvote}}, \code{\link[EFAfactors]{EFAscreet}},
         \code{\link[EFAfactors]{MAP}}, \code{\link[EFAfactors]{STOC}}
}
