% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_docid_reads.R
\name{get_docid_reads}
\alias{get_docid_reads}
\title{Get doc ID reads}
\usage{
get_docid_reads(scope, identifier, as = "data.frame", env = "production")
}
\arguments{
\item{scope}{(character) Scope of data package}

\item{identifier}{(numeric) Identifier of data package}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Summary of all the successful reads 
(total reads and non-robot reads) for all the resources of a given 
\code{scope} and \code{identifier}.
}
\description{
Get doc ID reads
}
\examples{
\dontrun{

# Get all reads
resourceReads <- get_docid_reads(scope = "knb-lter-sgs", identifier = 817)
}
}
\seealso{
Other Audit Manager Services: 
\code{\link{get_audit_count}()},
\code{\link{get_audit_csv_report}()},
\code{\link{get_audit_record}()},
\code{\link{get_audit_report}()},
\code{\link{get_packageid_reads}()},
\code{\link{get_recent_uploads}()}
}
\concept{Audit Manager Services}
