% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{edc_find_value}
\alias{edc_find_value}
\alias{edc_find_column}
\alias{find_keyword}
\title{Search the whole database}
\usage{
edc_find_value(
  keyword,
  ignore_case = TRUE,
  data = get_datasets(),
  lookup = edc_lookup()
)

edc_find_column(keyword, ignore_case = TRUE, lookup = edc_lookup())
}
\arguments{
\item{keyword}{The keyword to search for. Regular expressions are only supported in \code{edc_find_column}.}

\item{ignore_case}{Logical. If \code{TRUE} (default), the search will ignore case differences.}

\item{data}{A list of datasets.}

\item{lookup}{A lookup table.}
}
\value{
a tibble
}
\description{
Find a keyword in columns or values, in all the datasets of the database.
}
\examples{
db = edc_example()
load_database(db)

edc_find_value("respi")
edc_find_value(2010)

edc_find_column("ad")
edc_find_column("date") 
#with regex
edc_find_column("\\\\d")
edc_find_column("\\\\(") #you need to escape special characters
}
