% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{generate_differential_score_graph}
\alias{generate_differential_score_graph}
\title{Compute difference of interaction score of two groups}
\usage{
generate_differential_score_graph(interaction_score_graphs, settings)
}
\arguments{
\item{interaction_score_graphs}{[list] Named list with elements `groupA` and
`groupB` containing iGraph objects with weight and interaction_weight as edge attributes (output of
\code{\link[DrDimont]{generate_interaction_score_graphs}})}

\item{settings}{[list] A named list containing pipeline settings. The settings list has to be
initialized by \code{\link[DrDimont]{drdimont_settings}}. Items in the named list can be
adjusted as desired.}
}
\value{
iGraph object with `differential_score` and `differential_interaction_score` as edge attributes
}
\description{
Computes the absolute difference of interaction scores between
the two groups. Returns a single graph with the differential score and the
differential interaction score as edge attributes. The interaction score
is computed by \code{\link[DrDimont]{generate_interaction_score_graphs}}.
}
\examples{
data(interaction_score_graphs_example)

example_settings <- drdimont_settings()

example_differential_score_graph <- generate_differential_score_graph(
                                        interaction_score_graphs=interaction_score_graphs_example,
                                        settings=example_settings)

}
