
\newcommand{\opt}{\ifelse{latex}{\code{"#1"}}{\verb{"#1"}}}
\newcommand{\nl}{\ifelse{latex}{ }{\ifelse{html}{ }{ \cr}}}

\name{Didata}
\alias{Didata}
\alias{print.Didata}
\alias{summary.Didata}
\title{
Class methods for Didata Objects
}
\description{
Common functions to handle \opt{Didata} class results, which store all
data used in the modality analysis.
}

\usage{
\method{print}{Didata}(x, \dots)
\method{summary}{Didata}(object, \dots)
}

\arguments{
\item{x}{ an object of class \opt{Didata} }
\item{object}{ an object of class \opt{Didata} }
\item{\dots}{ extra arguments, ignored for all methods }
}

\details{
Didata is a matrix that contains all data used in the modality analysis,
with contents that depends on which analyses are run.  The matrix has one
column for each raw data point.  Dimodal creates the Didata object
internally; there is no public function to generate it.  Row \opt{xmid}
is the interpolated raw value for each index, as calculated by
\code{midquantile(data["xsort",], type=#)}, where the algorithm type is
provided by the option \opt{data.midq}.  Row \opt{signed} added by
the interval spacing analysis is its signed difference, where differences
within an order of magnitude of \code{.Machine.double.eps} are treated as
ties to avoid numerical precision errors.

The print method shows the source of the data and any filters applied to
the spacing.  It then prints a table with the valid columns, range of
values, and standard deviation of the original data and spacing.  If
low-pass and interval spacing were needed by \code{Dimodal}, then information
about them is added to the table.  The method uses option \opt{digits} to
control the number of significant digits for raw values.  If it is set to
zero then the standard \code{options()$digits} is used.

The summary method prints just the setup information.
}

\value{
The basic data stored in the matrix contains the rows
 \item{\code{x}}{ the original data }
 \item{\code{xsort}}{ sorted data }
 \item{\code{xmid}}{ the mid-distribution from \code{midquantile} }
 \item{\code{Di}}{ the spacing; index 1 is NA
   \nl }

If low-pass spacing is required, \code{Dimodal} adds the row
 \item{\code{lp}}{ spacing after low-pass filtering
   \nl }
where the leading and trailing columns are set to NA when part of the
filter falls outside the data.

If interval spacing is needed, the matrix also contains rows
 \item{\code{Diw}}{ the interval spacing }
 \item{\code{signed}}{ the signed difference of the interval spacing,
   with values -1, 0, +1 $ \nl }
where the leading columns up to the width of the interval are set NA.  The
signed difference has an additional NA.

Several bits of metadata are stored as attributes with the matrix, in
addition to any generated by R.  The basic analysis provides
 \item{\code{data.name}}{ the source of the data in the call to \code{Dimodal}
   \nl }
Low-pass filtering adds
 \item{\code{lp.kernel}}{ the name of the filter }
 \item{\code{lp.window}}{ the window or size of the filter, as provided
   by \code{Diopt}, which is normally a fraction of the data size but
   may also be in data points }
 \item{\code{wlp}}{ the actual window width in data points }
 \item{\code{lp.stID}}{ the first column in the matrix with valid
   low-pass values }
 \item{\code{lp.endID}}{ the last column (inclusive) that is valid
   \nl }
Interval spacing adds
 \item{\code{diw.window}}{ the interval size, as provided by \code{Diopt},
   which is normally a fraction of the data size but may also be in data
   points }
 \item{\code{wdiw}}{ the interval in data points }
 \item{\code{diw.stID}}{ the first column in the matrix with valid interval
   spacing; the last valid column is the end of the matrix
   \nl }

Note that the \code{signed} row starts one column after the interval spacing,
at \code{diw.stID + 1}, and runs to the end of the matrix.

The methods return the object, invisibly.
}

\seealso{
  \code{\link{Dimodal}},
  \code{\link{Diopt}},
  \code{\link{midquantile}}
}

\examples{
m <- Dimodal(faithful$eruptions, Diopt.local(diw.window=16))
m$data
}

\keyword{Didata}
\keyword{Dimodal}

