% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSSession.R
\name{dsIsReady}
\alias{dsIsReady}
\title{Get whether the remote R session is up and running}
\usage{
dsIsReady(session)
}
\arguments{
\item{session}{An object inheriting from \code{\link{DSSession-class}}.}
}
\value{
A logical
}
\description{
Get whether the remote R session is up and running, ready to accept R commands.
The primary use of this function is to know whether the session is ready after it has been
created in an asynchronous way.
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
session <- dsSession(con, async = TRUE)
ready <- dsIsReady(session)
while (!ready) {
  Sys.sleep(1)
  ready <- dsIsReady(session)
  cat(".")
}
dsDisconnect(con)
}
}
\seealso{
Other DSSession generics: 
\code{\link{DSSession-class}},
\code{\link{dsStateMessage}()}
}
\concept{DSSession generics}
