% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_pca.R
\name{cyt_pca}
\alias{cyt_pca}
\title{Analyze Data with Principal Component Analysis (PCA) for Cytokines.}
\usage{
cyt_pca(
  data,
  group_col = NULL,
  group_col2 = NULL,
  colors = NULL,
  output_file,
  ellipse = FALSE,
  comp_num = 2,
  scale = c("none", "log2", "log10", "zscore", "custom"),
  custom_fn = NULL,
  pch_values = NULL,
  style = NULL
)
}
\arguments{
\item{data}{A data frame containing cytokine data. It should include at
least one column representing grouping information and optionally a second
column representing treatment or stimulation.}

\item{group_col}{A string specifying the column name that contains the first group
information. If \code{group_col2} is not provided, an overall analysis will
be performed.}

\item{group_col2}{A string specifying the second grouping column. Default is
\code{NULL}.}

\item{colors}{A vector of colors corresponding to the groups.
If set to NULL, a palette is generated using \code{rainbow()} based on the
number of unique groups.}

\item{output_file}{Optional string specifying the name of the file
to be created.  When \code{NULL} (default), plots are drawn on
the current graphics device. Ensure that the file
extension matches the desired format (e.g., ".pdf" for PDF output
or ".png" for PNG output or .tiff for TIFF output).}

\item{ellipse}{Logical. If TRUE, a 95\% confidence ellipse is drawn on the
PCA individuals plot. Default is FALSE.}

\item{comp_num}{Numeric. The number of principal components to compute and
display. Default is 2.}

\item{scale}{Character string specifying a transformation to apply to
numeric variables before PCA.  Options are "none" (no
transformation), "log2", "log10", "zscore", or "custom".  When
"custom" is selected, a user supplied function must be given via
\code{custom_fn}.  Defaults to "none".}

\item{custom_fn}{A custom function used when \code{scale = "custom"}.
Should take a numeric vector and return a numeric vector.  Ignored
otherwise.}

\item{pch_values}{A vector of plotting symbols (pch values) to be used in
the PCA plots. Default is NULL.}

\item{style}{Character. If set to "3d" or "3D" and \code{comp_num} equals 3,
a 3D scatter plot is generated using the plot3D package. Default is NULL.}
}
\value{
A PDF file containing the PCA plots is generated and saved when
\code{output_file} is provided. Otherwise, plots are displayed on the current
graphics device.
}
\description{
This function performs Principal Component Analysis (PCA) on cytokine data
and generates several types of plots,
including:
\itemize{
\item 2D PCA plots using mixOmics' \code{plotIndiv} function,
\item 3D scatter plots (if \code{style} is "3d" or "3D" and
\code{comp_num} is 3) via the plot3D package,
\item Scree plots showing both individual and cumulative
explained variance,
\item Loadings plots, and
\item Biplots and correlation circle plots.
}
}
\examples{
# Load sample data
data <- ExampleData1[, -c(3,23)]
data_df <- dplyr::filter(data, Group != "ND" & Treatment != "Unstimulated")
# Run PCA analysis and save plots to a PDF file
cyt_pca(
  data = data_df,
  output_file = NULL,
  colors = c("black", "red2"),
  scale = "log2",
  comp_num = 3,
  pch_values = c(16, 4),
  style = "3D",
  group_col = "Group",
  group_col2 = "Treatment",
  ellipse = FALSE
)

}
\author{
Shubh Saraswat
}
