% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{cds_job_results}
\alias{cds_job_results}
\title{Get the results for a submitted job}
\usage{
cds_job_results(job_id, ..., token = cds_get_token())
}
\arguments{
\item{job_id}{Hexadecimal code used as identifier of a job. Identifies the job
for which to obtain the results.}

\item{...}{Ignored}

\item{token}{An API key to be used for authentication. Will use
\code{cds_get_token()} by default.}
}
\value{
Returns a \code{data.frame} with information about the requested job.
}
\description{
When a job is completed, you can get its results (i.e. download link)
by calling this function.
}
\examples{
if (interactive() && cds_token_works()) {
  job <- cds_submit_job(
      dataset        = "reanalysis-era5-pressure-levels",
      variable       = "geopotential",
      product_type   = "reanalysis",
      area           = c(n = 55, w = -1, s = 50, e = 10),
      year           = "2024",
      month          = "03",
      day            = "01",
      pressure_level = "1000",
      data_format    = "netcdf"
    )
  cds_job_results(job$jobID)
}
}
