% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subsets.R
\name{createLimitSubsetOperator}
\alias{createLimitSubsetOperator}
\title{Create Limit Subset Operator}
\usage{
createLimitSubsetOperator(
  name = NULL,
  priorTime = 0,
  followUpTime = 0,
  minimumCohortDuration = 0,
  maximumCohortDuration = NULL,
  limitTo = "all",
  calendarStartDate = NULL,
  calendarEndDate = NULL
)
}
\arguments{
\item{name}{Name of operation}

\item{priorTime}{Required prior observation window (specified as a positive integer)}

\item{followUpTime}{Required post observation window (specified as a positive integer)}

\item{minimumCohortDuration}{Required cohort duration length (specified as a positive integer)}

\item{maximumCohortDuration}{Optional: maximum cohort duration length (specified as a positive integer), defaults to NULL}

\item{limitTo}{character one of:
                             "firstEver" - only first entry in patient history
                             "earliestRemaining" - only first entry after washout set by priorTime
                             "latestRemaining" -  the latest remaining after washout set by followUpTime
                             "lastEver" - only last entry in patient history inside

                         Note, when using firstEver and lastEver with follow up and washout, patients with events
                         outside this will be censored. The "firstEver" and "lastEver" are applied first.
                         The "earliestRemaining" and "latestRemaining" are applied after all other limit
                         criteria are applied (i.e. after applying prior/post time and calendar time).}

\item{calendarStartDate}{End date to allow periods (e.g. 2020/1/1/)}

\item{calendarEndDate}{Start date to allow period (e.g. 2015/1/1)}
}
\description{
Subset cohorts using specified limit criteria
}
\seealso{
Other subsets: 
\code{\link{createCohortSubsetOperator}()},
\code{\link{createDemographicSubsetOperator}()}
}
\concept{subsets}
