% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unionCohorts.R
\name{unionCohorts}
\alias{unionCohorts}
\title{Generate cohort from the union of different cohorts}
\usage{
unionCohorts(
  cohort,
  cohortId = NULL,
  gap = 0,
  cohortName = NULL,
  keepOriginalCohorts = FALSE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to include
(cohort_definition_id or cohort_name). Cohorts not included will be
removed from the cohort set.}

\item{gap}{Number of days between two subsequent cohort entries to be merged
in a single cohort record.}

\item{cohortName}{Name of the returned cohort. If NULL, the cohort name will
be created by collapsing the individual cohort names, separated by "_".}

\item{keepOriginalCohorts}{If TRUE the original cohorts will be return
together with the new ones. If FALSE only the new cohort will be returned.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
A cohort table.
}
\description{
\code{unionCohorts()} combines different cohort entries, with those records
that overlap combined and kept. Cohort entries are when an individual was in
\emph{either} of the cohorts.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()

cdm$cohort2 <- cdm$cohort2 |>
  unionCohorts()

settings(cdm$cohort2)

}
}
