% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_deconv_pred_obs_data.R
\name{make_deconv_pred_obs_data}
\alias{make_deconv_pred_obs_data}
\title{Make tidy data for use in deconvolution plots}
\usage{
make_deconv_pred_obs_data(
  dat,
  true_values_col,
  predicted_cols,
  sample_id_col,
  group_col
)
}
\arguments{
\item{dat}{data.frame with predictions as columns, each row should be a prediction for a given sample and given group/celltype}

\item{true_values_col}{A string with the name of the column with the true values in `dat`. true values should be between 0 and 1.}

\item{predicted_cols}{A vector of strings with the name of the columns with the predictions for different methods in `dat`. predictions should be between 0 and 1}

\item{sample_id_col}{A string with the name of the column with the sample name or ID in `dat`.}

\item{group_col}{A string with the name of the column containing the cell types or groups in `dat`. group col should be a factor, otherwise the function will make it a factor}
}
\value{
tibble with tidied up deconvolution performance data in nested fields
}
\description{
Produces data with varied deconvolution performance metrics.
}
