% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_BEI_Weighting.R
\name{BEI_ProbsWeighting}
\alias{BEI_ProbsWeighting}
\title{Computing the weighted tercile probabilities for SFSs.}
\usage{
BEI_ProbsWeighting(
  var_exp,
  aweights,
  terciles,
  time_dim_name = "time",
  memb_dim = "member"
)
}
\arguments{
\item{var_exp}{Variable (e.g. precipitation, temperature, NAO index)
array from a SFS with at least dimensions (time, member) for a spatially 
aggregated variable or dimensions (time, member, lat, lon) for a spatial 
variable, as 'time' the spatial dimension by default.}

\item{aweights}{Normalized weights array with at least dimensions 
(time, member), when 'time' is the temporal dimension as default.}

\item{terciles}{A numeric array with at least one dimension 'tercil' equal to 
2, the first element is the lower tercil for a hindcast period, and the second  
element is the upper tercile.}

\item{time_dim_name}{A character string indicating the name of the 
temporal dimension, by default 'time'.}

\item{memb_dim}{A character string indicating the name of the 
member dimension, by default 'member'.}
}
\value{
BEI_ProbsWeighting() returns an array with at least two or four 
dimensions depending if the variable is a spatially aggregated variable 
(as e.g. NAO index)(time, tercil) or it is spatial variable (as e.g. 
precipitation or temperature)(time, tercile, lat, lon), containing the 
terciles probabilities computing with weighted members.
The first tercil is the lower tercile, the second is the normal tercile and
the third is the upper tercile.
}
\description{
This function implements the computation to obtain the tercile
probabilities for a weighted variable for SFSs using a normalized weights array,
}
\examples{
# Example 1 
var_exp <- 1 : (2 * 4)
dim(var_exp) <- c(time = 2, member = 4)
aweights <- c(0.2, 0.1, 0.3, 0.4, 0.1, 0.2, 0.4, 0.3)
dim(aweights) <- c(time = 2, member = 4)
terciles <- c(2.5,5)
dim(terciles) <- c(tercil = 2)
res <- BEI_ProbsWeighting(var_exp, aweights, terciles)

# Example 2 
var_exp <- rnorm(48, 50, 9)
dim(var_exp) <- c(time = 2, member = 4, lat = 2, lon = 3)
aweights <- c(0.2, 0.1, 0.3, 0.4, 0.1, 0.2, 0.4, 0.3)
dim(aweights) <- c(time = 2, member = 4)
terciles <- rep(c(48,50), 2*3)
dim(terciles) <- c(tercil = 2, lat = 2, lon = 3)
res <- BEI_ProbsWeighting(var_exp, aweights, terciles)
}
\references{
Regionally improved seasonal forecast of precipitation through Best
estimation of winter NAO, Sanchez-Garcia, E. et al.,
Adv. Sci. Res., 16, 165174, 2019, \doi{10.5194/asr-16-165-2019}
}
\author{
Eroteida Sanchez-Garcia - AEMET, \email{esanchezg@aemet.es}
}
