% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_enrichscore.R
\name{CAESAR.CTDEP}
\alias{CAESAR.CTDEP}
\title{Test Cell Type Differentially Enriched Pathways}
\usage{
CAESAR.CTDEP(
  seu,
  pathway_scores,
  ident = NULL,
  cts = NULL,
  parallel = TRUE,
  ncores = 10,
  seed = 1
)
}
\arguments{
\item{seu}{A Seurat object containing the single-cell RNA-seq data.}

\item{pathway_scores}{A matrix of pathway scores where rows represent cells and columns represent different pathways.}

\item{ident}{A character string specifying the column name in the Seurat object's metadata to use as the cell type labels. If \code{NULL}, the default identities (\code{Idents(seu)}) will be used. Default is \code{NULL}.}

\item{cts}{A character vector specifying the cell types to test. If \code{NULL}, the function will test all unique cell types present in \code{ident} or \code{Idents(seu)}. Default is \code{NULL}.}

\item{parallel}{Logical, indicating whether to run the computation in parallel. Default is \code{TRUE}.}

\item{ncores}{An integer specifying the number of cores to use for parallel computation. Default is 10.}

\item{seed}{An integer specifying the random seed for reproducibility in parallel computation. Default is 1.}
}
\value{
A matrix of p-values where rows represent the pathways and columns represent the tested cell types.
}
\description{
This function tests whether specific pathways are differentially enriched in particular cell types with cell types stored in a Seurat object. The function applies the Wilcoxon rank-sum test to compare the pathway scores between cells of a given cell type and all other cells. It supports parallel computation to speed up the testing process.
}
\examples{
data(toydata)

seu <- toydata$seu
pathway_list <- toydata$pathway_list
cts <- levels(seu)[1:2]

enrich.score <- CAESAR.enrich.score(seu, pathway_list)
dep.pvals <- CAESAR.CTDEP(seu, enrich.score, cts = cts)
print(dep.pvals)

}
\seealso{
\code{\link[stats]{wilcox.test}} for the Wilcoxon rank-sum test.
\code{\link{CAESAR.enrich.score}} for spot level pathway enrich scores.
}
