% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_stripe_patterns}
\alias{simulate_stripe_patterns}
\title{Simulate Stripe Patterns}
\usage{
simulate_stripe_patterns(
  grid_size = 100,
  gap_seq = c(10),
  width_seq = c(5),
  theta_seq = c(0),
  eps = 1e-09,
  verbose = TRUE
)
}
\arguments{
\item{grid_size}{Size of the spatial grid (default: 100)}

\item{gap_seq}{Vector of gap distances between stripe centers (default: c(10))}

\item{width_seq}{Vector of stripe widths (default: c(5))}

\item{theta_seq}{Vector of rotation angles in degrees (default: c(0))}

\item{eps}{Small numeric value for open boundary conditions to avoid overlap at stripe edges (default: 1e-9)}

\item{verbose}{Logical; if TRUE, show progress messages (default: TRUE)}
}
\value{
List of data frames, each containing X, Y coordinates and signal_1, signal_2 binary signals
}
\description{
Generate stripe patterns with two parallel stripes separated by a gap.
Creates rotatable stripe patterns with configurable gap, width, and rotation angle.
}
\examples{
\donttest{
# Generate stripe patterns with default parameters
patterns <- simulate_stripe_patterns()

# Custom parameters
patterns <- simulate_stripe_patterns(
  grid_size = 80,
  gap_seq = c(10, 20),
  width_seq = c(5, 10, 20),
  theta_seq = c(0, 30, 60),
  eps = 1e-9,
  verbose = TRUE
)
}
}
