% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.props}
\alias{BF10.props}
\title{Bayes factor for comparing two proportions}
\usage{
BF10.props(a0, b0, a1, b1, a2, b2, n1, n2, x1, x2)
}
\arguments{
\item{a0}{Numeric scalar. Alpha parameter of the Beta prior under the null hypothesis.}

\item{b0}{Numeric scalar. Beta parameter of the Beta prior under the null hypothesis.}

\item{a1}{Numeric scalar. Alpha parameter of the Beta prior for group 1 under the alternative hypothesis.}

\item{b1}{Numeric scalar. Beta parameter of the Beta prior for group 1 under the alternative hypothesis.}

\item{a2}{Numeric scalar. Alpha parameter of the Beta prior for group 2 under the alternative hypothesis.}

\item{b2}{Numeric scalar. Beta parameter of the Beta prior for group 2 under the alternative hypothesis.}

\item{n1}{Numeric integer. Sample size for group 1.}

\item{n2}{Numeric integer. Sample size for group 2.}

\item{x1}{Numeric integer. Number of successes observed in group 1.}

\item{x2}{Numeric integer. Number of successes observed in group 2.}
}
\value{
A list of class \code{BFvalue_2p} containing:
\itemize{
\item \code{type}: the string "Two-proportions".
\item \code{analysis_h0}: list with \code{a} and \code{b} for the null prior.
\item \code{analysis_h1_theta_1}: list with \code{a} and \code{b} for group 1 prior under H1.
\item \code{analysis_h1_theta_2}: list with \code{a} and \code{b} for group 2 prior under H1.
\item \code{bf10}: the computed Bayes factor (BF10).
\item \code{n1}, \code{x1}, \code{n2}, \code{x2}: the input sample sizes and observed successes.
\item \code{OddRatio}: observed odd ratio.
\item \code{p.value}: p.value.
}
}
\description{
Compute the Bayes factor (BF10) for a Bayesian test of two proportions.
}
\examples{
BF10.props(
a0 = 1,
b0 = 1,
a1 = 1,
b1 = 1,
a2 = 1,
b2 = 1,
n1 = 493,
n2 = 488,
x1 = 155,
x2 = 150)
}
