% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\name{aeSkewness}
\alias{aeSkewness}
\title{Asymptotic Expansion - Skewness}
\usage{
aeSkewness(ae, eps = 1, order = NULL)
}
\arguments{
\item{ae}{an object of class \code{\link{yuima.ae-class}}.}

\item{eps}{numeric. The intensity of the perturbation.}

\item{order}{integer. The expansion order. If \code{NULL} (default), it uses the maximum order used in \code{ae}.}
}
\value{
numeric.
}
\description{
Asymptotic Expansion - Skewness
}
\examples{
\dontrun{
# model
gbm <- setModel(drift = 'mu*x', diffusion = 'sigma*x', solve.variable = 'x')

# settings
xinit <- 100
par <- list(mu = 0.01, sigma = 0.2)
sampling <- setSampling(Initial = 0, Terminal = 1, n = 1000)

# asymptotic expansion
approx <- ae(model = gbm, sampling = sampling, order = 4, true.parameter = par, xinit = xinit)

# expansion order max
aeSkewness(ae = approx)

# expansion order 1
aeSkewness(ae = approx, order = 1)
}
}
