% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.predxhaz.R
\name{plot.predxhaz}
\alias{plot.predxhaz}
\title{plots of excess hazard and net Survival from an
\code{predxhaz} object}
\usage{
\method{plot}{predxhaz}(x, what = "survival", ...)
}
\arguments{
\item{x}{An object of class predxhaz}

\item{what}{allow to choose between excess hazard
(\code{what="hazard"}) or net survival (\code{what="survival"}).}

\item{...}{additional arguments affecting the plot function}
}
\value{
The return of this function produce graphics of excess hazard or net
survival, or time-dependent effects, when times.pts argument is provided
in prediction call.
}
\description{
Function to plot excess hazard or net survival
}
\examples{
\donttest{
data("dataCancer")
# load the data set in the package
library("survival")
library("numDeriv")
library("survexp.fr")
data("simuData", package = "xhaz") # load the data sets 'simuData'

#define the levels of variable sex

# Esteve et al. model


fit.estv1 <- xhaz(formula = Surv(time_year, status) ~ agec + race,
                  data = simuData, ratetable = survexp.us,
                  interval = c(0, NA, NA, NA, NA, NA, max(simuData$time_year)),
                  rmap = list(age = 'age', sex = 'sex', year = 'date'),
                  baseline = "constant", pophaz = "classic")


predict_est <- predict(object = fit.estv1,
                       new.data = simuData,
                       times.pts = c(seq(0, 4, 0.1)),
                       baseline = TRUE)

plot(predict_est, what = "survival",
     xlab = "time since diagnosis (year)",
     ylab = "net survival", ylim = c(0, 1))
data("dataCancer", package = "xhaz")   # load the data set in the package

fit.phBS <- xhaz(
      formula = Surv(obs_time_year, event) ~ ageCentre + immuno_trt,
      data = dataCancer, ratetable = survexp.fr::survexp.fr,
      interval = c(0, NA, NA, max(dataCancer$obs_time_year)),
      rmap = list(age = 'age', sex = 'sexx', year = 'year_date'),
      baseline = "bsplines", pophaz  = "classic")


predict_mod1 <- predict(object = fit.phBS, new.data = dataCancer,
                        times.pts = c(seq(0, 10, 0.1)), baseline = FALSE)

old.par <- par(no.readonly = TRUE)
par(mfrow = c(2, 1))


plot(predict_mod1, what = "survival",
     xlab = "time since diagnosis (year)",
     ylab = "net survival", ylim = c(0, 1))

plot(predict_mod1, what = "hazard",
     xlab = "time since diagnosis (year)",
     ylab = "excess hazard")

par(old.par)
}
}
\references{
Goungounga JA, Touraine C, Graff\'eo N, Giorgi R;
CENSUR working survival group. Correcting for misclassification
and selection effects in estimating net survival in clinical trials.
BMC Med Res Methodol. 2019 May 16;19(1):104.
doi: 10.1186/s12874-019-0747-3. PMID: 31096911; PMCID: PMC6524224.
(\href{https://pubmed.ncbi.nlm.nih.gov/31096911/}{PubMed})

Touraine C, Graff\'eo N, Giorgi R; CENSUR working survival group.
More accurate cancer-related excess mortality through correcting
background mortality for extra variables.
Stat Methods Med Res. 2020 Jan;29(1):122-136.
doi: 10.1177/0962280218823234. Epub 2019 Jan 23. PMID: 30674229.
(\href{https://pubmed.ncbi.nlm.nih.gov/30674229/}{PubMed})

Mba RD, Goungounga JA, Graff\'eo N, Giorgi R; CENSUR working survival group.
Correcting inaccurate background mortality in excess hazard models
through breakpoints. BMC Med Res Methodol. 2020 Oct 29;20(1):268.
doi: 10.1186/s12874-020-01139-z. PMID: 33121436; PMCID: PMC7596976.
(\href{https://pubmed.ncbi.nlm.nih.gov/33121436/}{PubMed})
}
\author{
Juste Goungounga, Robert Darlin Mba, Nathalie Graff\'eo and Roch Giorgi
}
\keyword{plot.predxhaz}
