% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{setGlobalTableOptions}
\alias{setGlobalTableOptions}
\title{Set format options for all subsequent tables}
\usage{
setGlobalTableOptions(style = NULL, type = NULL)
}
\arguments{
\item{style}{A character string or custom R code to define the visual
formatting of the table. This argument can be provided in two ways:
\enumerate{
\item Pre-defined Styles (Character String): Use a name for a built-in style
(e.g., "darwin"). See tableStyle() for available options.
\item Custom Code (Advanced): Supply a block of custom R code. This code must be
specific to the table type. See tableStyleCode() for structural examples.
}}

\item{type}{The desired format of the output table. See \code{tableType()} for
allowed options.}
}
\description{
Set format options for all subsequent tables unless state a different style
in a specific function
}
\examples{
setGlobalTableOptions(style = "darwin", type = "tinytable")
result <- mockSummarisedResult()
result |>
  visOmopTable(
    estimateName = c("N\%" = "<count> (<percentage>)",
                     "N" = "<count>",
                     "Mean (SD)" = "<mean> (<sd>)"),
    header = c("cohort_name"),
    rename = c("Database name" = "cdm_name"),
    groupColumn = strataColumns(result)
  )
 # drop global options:
 setGlobalTableOptions(style = NULL, type = NULL)

}
