% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{setGlobalPlotOptions}
\alias{setGlobalPlotOptions}
\title{Set format options for all subsequent plots}
\usage{
setGlobalPlotOptions(style = NULL)
}
\arguments{
\item{style}{Which style to apply to the plot, options are:
"default", "darwin" and NULL (default ggplot style).
Customised styles can be achieved by modifying the returned ggplot object.}
}
\description{
Set format options for all subsequent plots unless state a different style in
a specific function
}
\examples{
setGlobalPlotOptions(style = "darwin")

result <- mockSummarisedResult() |>
  dplyr::filter(variable_name == "age")

scatterPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  line = TRUE,
  point = TRUE,
  ribbon = FALSE,
  facet = age_group ~ sex)

}
