% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.stdmean.ps}
\alias{meta.ave.stdmean.ps}
\title{Confidence interval for an average standardized mean difference from
paired-samples studies}
\usage{
meta.ave.stdmean.ps(alpha, m1, m2, sd1, sd2, cor, n, stdzr, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for measurement 1}

\item{m2}{vector of estimated means for measurement 2}

\item{sd1}{vector of estimated SDs for measurement 1}

\item{sd2}{vector of estimated SDs for measurement 2}

\item{cor}{vector of estimated correlations for paired measurements}

\item{n}{vector of sample sizes}

\item{stdzr}{\itemize{
\item set to 0 for square root unweighted average variance standardizer
\item set to 1 for measurement 1 SD standardizer
\item set to 2 for measurement 2 SD standardizer
}}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average standardized mean difference from two or more paired-samples
studies. Squrare root Unweighted variances and a single condition standard
deviation are options for the standardizer. Equality of variances within
or across studies is not assumed.
}
\examples{
m1 <- c(23.9, 24.1)
m2 <- c(25.1, 26.9)
sd1 <- c(1.76, 1.58)
sd2 <- c(2.01, 1.76)
cor <- c(.78, .84)
n <- c(25, 30)
meta.ave.stdmean.ps(.05, m1, m2, sd1, sd2, cor, n, 1, bystudy = TRUE)

# Should return: 
#           Estimate        SE        LL         UL
# Average -1.1931045 0.1568034 -1.500433 -0.8857755
# Study 1 -0.6818182 0.1773785 -1.029474 -0.3341628
# Study 2 -1.7721519 0.2586234 -2.279044 -1.2652594


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
