% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.meanratio.ps}
\alias{meta.ave.meanratio.ps}
\title{Confidence interval for an average mean ratio from paired-samples studies}
\usage{
meta.ave.meanratio.ps(alpha, m1, m2, sd1, sd2, cor, n, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for measurement 1}

\item{m2}{vector of estimated means for measurement 2}

\item{sd1}{vector of estimated SDs for measurement 1}

\item{sd2}{vector of estimated SDs for measurement 2}

\item{cor}{vector of estimated correlations for paired measurements}

\item{n}{vector of sample sizes}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item exp(Estimate) - exponentiated estimate
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
\item df - degrees of freedom
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
geometric average mean ratio from two or more paired-samples studies. A
Satterthwaite adjustment to the degrees of freedom is used to improve the
accuracy of the confidence interval for the average effect size. Equality
of variances within or across studies is not assumed.
}
\examples{
m1 <- c(53, 60, 53, 57)
m2 <- c(55, 62, 58, 61)
sd1 <- c(4.1, 4.2, 4.5, 4.0)
sd2 <- c(4.2, 4.7, 4.9, 4.8)
cor <- c(.7, .7, .8, .85)
n <- c(30, 50, 30, 70)
meta.ave.meanratio.ps(.05, m1, m2, sd1, sd2, cor, n, bystudy = TRUE)

# Should return:
#            Estimate          SE          LL          UL
# Average -0.05695120 0.004350863 -0.06558008 -0.04832231
# Study 1 -0.03704127 0.010871086 -0.05927514 -0.01480740
# Study 2 -0.03278982 0.008021952 -0.04891054 -0.01666911
# Study 3 -0.09015110 0.009779919 -0.11015328 -0.07014892
# Study 4 -0.06782260 0.004970015 -0.07773750 -0.05790769
#         exp(Estimate)   exp(LL)   exp(UL)       df
# Average     0.9446402 0.9365240 0.9528266 103.0256
# Study 1     0.9636364 0.9424474 0.9853017  29.0000
# Study 2     0.9677419 0.9522663 0.9834691  49.0000
# Study 3     0.9137931 0.8956968 0.9322550  29.0000
# Study 4     0.9344262 0.9252073 0.9437371  69.0000


}
