% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.agree}
\alias{meta.ave.agree}
\title{Confidence interval for an average G-index agreement coefficient}
\usage{
meta.ave.agree(alpha, f11, f12, f21, f22, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{vector of frequency counts in cell 1,1}

\item{f12}{vector of frequency counts in cell 1,2}

\item{f21}{vector of frequency counts in cell 2,1}

\item{f22}{vector of frequency counts in cell 2,2}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average G-index of agreement from two or more studies. This function
assumes that two raters each provide a dichotomous rating to a sample
of objects. As a measure of agreement, the G-index is usually preferred
to Cohen's kappa.
}
\examples{
f11 <- c(43, 56, 49)
f12 <- c(7, 2, 9)
f21 <- c(3, 5, 5)
f22 <- c(37, 54, 39)
meta.ave.agree(.05, f11, f12, f21, f22, bystudy = TRUE)

# Should return:
#          Estimate         SE        LL        UL
# Average 0.7843250 0.03540254 0.7149373 0.8537127
# Study 1 0.7446809 0.06883919 0.6097585 0.8796032
# Study 2 0.8512397 0.04770701 0.7577356 0.9447437
# Study 3 0.6981132 0.06954284 0.5618117 0.8344147


}
