% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StAndrews.R
\docType{data}
\name{standrews_1}
\alias{standrews_1}
\title{Primary colours of the University of St Andrews, Scotland}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on \href{https://www.st-andrews.ac.uk}{St Andrews}' 
\href{https://www.st-andrews.ac.uk/brand/design-guidelines/colours/}{design guidelines}.
}
\usage{
standrews_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{standrews_1} provides the four primary colours 
of the \href{https://www.st-andrews.ac.uk}{University of St Andrews}, Scotland, UK.
}
\details{
The 4 primary colors are 
\code{"St Andrews blue"} (defined as HEX #00539b), 
\code{"St Andrews red"} (defined as HEX #ee312a), 
\code{"St Andrews yellow"} (defined as HEX #ffdf00), and 
\code{"St Andrews black"} (defined as HEX #231f20). 

\code{standrews_1} uses these HEX colour definitions.
}
\examples{
standrews_1
unikn::seecol(standrews_1, col_bg = "grey96", 
              main = "Primary colours of the University of St Andrews") # view palette

}
\seealso{
\code{\link{standrews_2}} for secondary colours of St. Andrews;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Scottish university color palettes: 
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh}},
\code{\link{standrews_2}},
\code{\link{stirling_1}},
\code{\link{stirling_2}},
\code{\link{stirling_3}}
}
\author{
\strong{unicol}, 2023-07-16.
}
\concept{Scottish university color palettes}
\keyword{datasets}
