% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPG.R
\docType{data}
\name{mpg}
\alias{mpg}
\title{Default colors of the Max-Planck-Gesellschaft (MPG), Germany}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
\url{https://docplayer.org/2328711-Max-planck-institut-das-erscheinungsbild-der-max-planck-gesellschaft-4-ueberarbeitete-auflage.html}.
}
\usage{
mpg
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{mpg} provides the default color palette 
of the \href{https://www.mpg.de/en}{Max Planck Society}, Germany.
}
\details{
The two primary colors are at the extreme positions of \code{mpg}: 
\enumerate{
\item \code{MPG green} (at \code{mpg[1]}): Defined as \code{Pantone 328}, \code{CMYK 100/0/57/30}, or \code{RGB 17/102/86}.
\item \code{MPG grey} (at \code{mpg[5]}): Defined as \code{Pantone 427}, \code{CMYK 0/0/6/15}, or \code{RGB 221/222/214}.
}

At \code{mpg[3]}, the color \code{"white"} was added to enable symmetrical color gradients. 
See examples and the \code{\link{ac}} and \code{\link{usecol}} functions 
for creating color gradients.
}
\examples{
mpg
unikn::seecol(mpg, main = "Colors of the Max Planck Society")  # view color palette 
unikn::demopal(mpg, type = 1, main = "Using the MPG colors")

# Extended version:
mpg_11 <- unikn::usecol(c(mpg, "black"), n = 11)
unikn::demopal(mpg_11, type = 4, seed = 1, main = "An extended MPG palette")

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.
}
\author{
\strong{unicol}, 2022-12-11.
}
\concept{Research society color palettes}
\keyword{datasets}
