% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Concordia.R
\docType{data}
\name{concordia_2}
\alias{concordia_2}
\title{Secondary colours of Concordia University, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on \href{https://www.concordia.ca}{Concordia}'s 
\href{https://www.concordia.ca/web/design/ui-kit-style-guide-accessibility/web-palette-new.html}{web colour palette}.
}
\usage{
concordia_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{concordia_2} provides the four secondary colours 
of \href{https://www.concordia.ca}{Concordia University}, Canada.
}
\details{
The 4 secondary colours are
\code{"Yellow"} (defined as HEX #e5a712),
\code{"Gold"} (defined as HEX #cbb576), 
\code{"Cyan"} (defined as HEX #00adef), and
\code{"Lime"} (defined as HEX #8cc63e).

\code{concordia_2} uses the HEX color definitions.
}
\examples{
concordia_2
unikn::seecol(concordia_2, main = "Secondary colours of Concordia University")  # view palette

}
\seealso{
\code{\link{concordia_1}} for primary colours of Concordia University;
\code{\link{concordia_3}} for background tints of Concordia University;
\code{\link{concordia_4}} for neutral colours of Concordia University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-26.
}
\concept{Canadian university color palettes}
\keyword{datasets}
