% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cardiff.R
\docType{data}
\name{cardiff_2}
\alias{cardiff_2}
\title{Secondary colour examples of Cardiff University, Wales}
\format{
An object of class \code{character} of length 9.
}
\source{
Colour definitions are based on \href{https://www.cardiff.ac.uk}{Cardiff University}'s 
User Experience Style Guide (PDF, v2 of 04/06/2013).
}
\usage{
cardiff_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{cardiff_2} provides examples of secondary colours (in 3 tints)
of the \href{https://www.cardiff.ac.uk}{Cardiff University}, Wales, UK.
}
\details{
The secondary \href{https://www.cardiff.ac.uk}{Cardiff University} 
colour palette will be used when deviating from the main site 
into different subsites and areas.


The rule is open on colour choice but the chosen palette needs to
contain 3 tints of the same colour, to allow for backgrounds, 
button overstates etc.

See the \code{\link{shades_of}} or \code{\link{usecol}} functions 
of \strong{unikn} for creating colour gradients.
}
\examples{
cardiff_2
unikn::seecol(cardiff_2, main = "Secondary colours of Cardiff University (3 tints)")

}
\seealso{
\code{\link{cardiff_1}} for primary colours of Cardiff University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Welsh university color palettes: 
\code{\link{aberystwyth_1}},
\code{\link{aberystwyth_2}},
\code{\link{bangor_1}},
\code{\link{bangor_2}},
\code{\link{bangor_3}},
\code{\link{bangor_4}},
\code{\link{cardiff_1}}
}
\author{
\strong{unicol}, 2023-09-10.
}
\concept{Welsh university color palettes}
\keyword{datasets}
