% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxSexLim.R
\name{umxPlotSexLim}
\alias{umxPlotSexLim}
\alias{plot.MxModelSexLim}
\title{Draw and display a graphical figure of a Sex limitation model}
\usage{
umxPlotSexLim(
  x = NA,
  file = "name",
  digits = 2,
  means = FALSE,
  std = TRUE,
  format = c("current", "graphviz", "DiagrammeR"),
  SEstyle = FALSE,
  strip_zero = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{\link[OpenMx:mxModel]{OpenMx::mxModel()}} to display graphically}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{SEstyle}{report "b (se)" instead of "b [lower, upper]" (Default)}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Optional additional parameters}
}
\value{
\itemize{
\item Optionally return the dot code
}
}
\description{
Will plot a graphical figure for a sex limitation model.
Options include \code{digits} (rounding), showing \code{means} or not, and which output \code{format} is desired.
}
\examples{
\dontrun{
require(umx)
umx_set_optimizer("SLSQP")
data("us_skinfold_data")
# Rescale vars
us_skinfold_data[, c('bic_T1', 'bic_T2')] = us_skinfold_data[, c('bic_T1', 'bic_T2')]/3.4
us_skinfold_data[, c('tri_T1', 'tri_T2')] = us_skinfold_data[, c('tri_T1', 'tri_T2')]/3
us_skinfold_data[, c('caf_T1', 'caf_T2')] = us_skinfold_data[, c('caf_T1', 'caf_T2')]/3
us_skinfold_data[, c('ssc_T1', 'ssc_T2')] = us_skinfold_data[, c('ssc_T1', 'ssc_T2')]/5
us_skinfold_data[, c('sil_T1', 'sil_T2')] = us_skinfold_data[, c('sil_T1', 'sil_T2')]/5

# Data for each of the 5 twin-type groups
mzmData = subset(us_skinfold_data, zyg == 1)
mzfData = subset(us_skinfold_data, zyg == 2)
dzmData = subset(us_skinfold_data, zyg == 3)
dzfData = subset(us_skinfold_data, zyg == 4)
dzoData = subset(us_skinfold_data, zyg == 5)

# ==========================
# = Run univariate example =
# ==========================
m1 = umxSexLim(selDVs = "bic", sep = "_T", A_or_C = "A", autoRun= FALSE,
	mzmData = mzmData, dzmData = dzmData, 
	mzfData = mzfData, dzfData = dzfData, 
	dzoData = dzoData
)
m1 = mxTryHard(m1)
umxPlotSexLim(m1)
plot(m1) # no need to remember a special name: plot works fine!
}
}
\references{
\itemize{
\item \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umxSexLim]{umxSexLim()}}, \code{\link[=umxSummarySexLim]{umxSummarySexLim()}}
}

Other Plotting functions: 
\code{\link{ggAddR}()},
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{umx}},
\code{\link{umxPlot}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotFun}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSimplex}()}
}
\concept{Plotting functions}
