% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_highlight}
\alias{txt_highlight}
\title{Highlight words in a character vector}
\usage{
txt_highlight(x, terms)
}
\arguments{
\item{x}{a character vector with text}

\item{terms}{a vector of words to highlight which appear in \code{x}}
}
\value{
A character vector with the same length of \code{x} where the terms provided in \code{terms}
are put in between || to highlight them
}
\description{
Highlight words in a character vector. The words provided in \code{terms} are 
highlighted in the text by wrapping it around the following charater: |.
So 'I like milk and sugar in my coffee' would give 'I like |milk| and sugar in my coffee' if you 
want to highlight the word milk
}
\examples{
x <- "I like milk and sugar in my coffee."
txt_highlight(x, terms = "sugar")
txt_highlight(x, terms = c("milk", "my"))
}
