% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_flow.R
\name{dtm_tfidf}
\alias{dtm_tfidf}
\title{Term Frequency - Inverse Document Frequency calculation}
\usage{
dtm_tfidf(dtm)
}
\arguments{
\item{dtm}{an object returned by \code{\link{document_term_matrix}}}
}
\value{
a vector with tfidf values, one for each term in the \code{dtm} matrix
}
\description{
Term Frequency - Inverse Document Frequency calculation.
Averaged by each term.
}
\examples{
data(brussels_reviews_anno)
x <- subset(brussels_reviews_anno, xpos == "NN")
x <- x[, c("doc_id", "lemma")]
x <- document_term_frequencies(x)
dtm <- document_term_matrix(x)

## Calculate tfidf
tfidf <- dtm_tfidf(dtm)
hist(tfidf, breaks = "scott")
head(sort(tfidf, decreasing = TRUE))
head(sort(tfidf, decreasing = FALSE))
}
