% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongToWide.R
\name{LongToWide}
\alias{LongToWide}
\title{Function to transpose the data from long to wide format}
\usage{
LongToWide(subject.id, time.sequence, outcome, verbose = FALSE)
}
\arguments{
\item{subject.id}{a column of subject identifiers}

\item{time.sequence}{a column of time points}

\item{outcome}{a column to be transposed}

\item{verbose}{TRUE or FALSE (default = FALSE) prints output to screen 
(OPTIONAL INPUT)}
}
\value{
\item{\code{mat.wide }}{a matrix in wide format, in which each
column is the outcome for each subject and each row is the time sequence}
}
\description{
Transposing a dataset with repeated measurements/responses for each subject 
from longitudinal to wide format.
}
\details{
If data is not sorted by subject.id, a warning message will appear. 
The function will then sort the data by subject.id. It is recommended that the 
user sorts the data prior to using this function.
}
\examples{
# CREATING A TRANSPOSED MATRIX FOR MEDIATOR `WantToSmokeLst15min`
data(smoker)
mat.wide <- LongToWide(smoker$SubjectID,
                       smoker$timeseq,
                       smoker$WantToSmokeLst15min)

}
