% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_answers.R
\name{write_answers}
\alias{write_answers}
\title{Write tutorial answers to file}
\usage{
write_answers(file, session, is_test = FALSE)
}
\arguments{
\item{file}{Location to render answers to. Output file type determined by
file suffix. Only "html" is acceptable.}

\item{session}{Session object from \code{Shiny} with \code{learnr}.}

\item{is_test}{\code{TRUE}/\code{FALSE} depending on whether or not we are just testing
the function. Default is \code{TRUE}.}
}
\description{
Take a tutorial session, extract out all the submitted answers,
and write out an html file with all of those answers.
}
\details{
We only keep track of the questions/exercises that the student has
completed. The other obvious approach is to keep all the
questions/exercises and leave unanswered ones as NA. Not sure if that
approach is better, or even possible.
}
\examples{
if(interactive()){
  write_answers("getting-started_answers.html", sess)
}

}
