% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discords.R
\name{discords}
\alias{discords}
\title{Search for Discord}
\usage{
discords(
  profile,
  exclusion_zone = profile$ez,
  k = 3L,
  neighbor_count = 10L,
  radius = 3
)
}
\arguments{
\item{profile}{a \code{MatrixProfile} or \code{PMP} object.}

\item{exclusion_zone}{an \code{int}. Number of values to exclude on both sides of the motif to avoid trivial matches.
Defaults to the exclusion zone used to compute the (Pan-)Matrix Profile which is found in the profile data structure.}

\item{k}{an \code{int}. Number of discords to find. (Default is \code{3}).}

\item{neighbor_count}{an \code{int}. Number of neighbors to find. (Default is \code{3}).}

\item{radius}{an \code{int}. Set a threshold to exclude matching neighbors with distance > current
discord distance * \code{radius}. (Default is \code{3}).}
}
\description{
Search for Discord
}
\references{
Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other Main API: 
\code{\link{analyze}()},
\code{\link{compute}()},
\code{\link{motifs}()},
\code{\link{visualize}()}
}
\concept{Main API}
