% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msm.R
\name{msm}
\alias{msm}
\title{Marginal Structural Model (MSM) for Treatment Switching}
\usage{
msm(
  data,
  id = "id",
  stratum = "",
  tstart = "tstart",
  tstop = "tstop",
  event = "event",
  treat = "treat",
  swtrt = "swtrt",
  swtrt_time = "swtrt_time",
  base_cov = "",
  numerator = "",
  denominator = "",
  strata_main_effect_only = TRUE,
  ns_df = 3,
  firth = FALSE,
  flic = FALSE,
  stabilized_weights = TRUE,
  trunc = 0,
  trunc_upper_only = TRUE,
  swtrt_control_only = TRUE,
  treat_alt_interaction = TRUE,
  alpha = 0.05,
  ties = "efron",
  boot = FALSE,
  n_boot = 1000,
  seed = 0,
  nthreads = 0
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{id}: The id to identify observations belonging to the same
subject for counting process data with time-dependent covariates.
\item \code{stratum}: The stratum.
\item \code{tstart}: The starting time of the time interval for
counting-process data with time-dependent covariates.
\item \code{tstop}: The stopping time of the time interval for
counting-process data with time-dependent covariates.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{treat}: The randomized treatment indicator, 1=treatment,
0=control.
\item \code{swtrt}: The treatment switch indicator, 1=switch, 0=no switch.
\item \code{swtrt_time}: The time from randomization to treatment switch.
\item \code{base_cov}: The baseline covariates (excluding treat) used in
the outcome model.
\item \code{numerator}: The baseline covariates (excluding treat) used in
the numerator switching model for stabilized weights.
\item \code{denominator}: The baseline (excluding treat) and time-dependent
covariates used in the denominator switching model.
}}

\item{id}{The name of the id variable in the input data.}

\item{stratum}{The name(s) of the stratum variable(s) in the input data.}

\item{tstart}{The name of the tstart variable in the input data.}

\item{tstop}{The name of the tstop variable in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{swtrt}{The name of the swtrt variable in the input data.}

\item{swtrt_time}{The name of the swtrt_time variable in the input data.}

\item{base_cov}{The names of baseline covariates (excluding
treat) in the input data for the Cox model.}

\item{numerator}{The names of baseline covariates
(excluding treat) in the input data for the numerator switching
model for stabilized weights.}

\item{denominator}{The names of baseline  (excluding treat) and
time-dependent covariates in the input data for the denominator
switching model.}

\item{strata_main_effect_only}{Whether to only include the strata main
effects in the logistic regression switching model. Defaults to
\code{TRUE}, otherwise all possible strata combinations will be
considered in the switching model.}

\item{ns_df}{Degrees of freedom for the natural cubic spline for
visit-specific intercepts of the pooled logistic regression model.
Defaults to 3 for two internal knots at the 33 and 67 percentiles
of the treatment switching times.}

\item{firth}{Whether the Firth's bias reducing penalized likelihood
should be used.}

\item{flic}{Whether to apply intercept correction to obtain more
accurate predicted probabilities.}

\item{stabilized_weights}{Whether to use the stabilized weights.
The default is \code{TRUE}.}

\item{trunc}{The truncation fraction of the weight distribution.
Defaults to 0 for no truncation in weights.}

\item{trunc_upper_only}{Whether to truncate the weights from the upper
end of the weight distribution only. Defaults to \code{TRUE}, otherwise
the weights will be truncated from both the lower and upper ends of
the distribution.}

\item{swtrt_control_only}{Whether treatment switching occurred only in
the control group. The default is \code{TRUE}.}

\item{treat_alt_interaction}{Whether to include an interaction between
randomized and alternative treatments in the outcome model
when both randomized arms can switch to alternative treatment.}

\item{alpha}{The significance level to calculate confidence intervals.}

\item{ties}{The method for handling ties in the Cox model, either
"breslow" or "efron" (default).}

\item{boot}{Whether to use bootstrap to obtain the confidence
interval for hazard ratio. Defaults to \code{FALSE}.}

\item{n_boot}{The number of bootstrap samples.}

\item{seed}{The seed to reproduce the bootstrap results.}

\item{nthreads}{The number of threads to use in bootstrapping (0 means
the default RcppParallel behavior)}
}
\value{
A list with the following components:
\itemize{
\item \code{pvalue}: The two-sided p-value.
\item \code{pvalue_type}: The type of two-sided p-value for treatment effect,
i.e., "Cox model" or "bootstrap".
\item \code{hr}: The estimated hazard ratio from the Cox model.
\item \code{hr_CI}: The confidence interval for hazard ratio.
\item \code{hr_CI_type}: The type of confidence interval for hazard ratio,
either "Cox model" or "bootstrap".
\item \code{event_summary}: A data frame containing the count and percentage
of deaths and switches by treatment arm.
\item \code{data_switch}: A list of input data for the switching models by
treatment group. The variables include \code{id}, \code{stratum},
\code{"tstart"}, \code{"tstop"}, \code{"cross"}, \code{denominator},
\code{swtrt}, and \code{swtrt_time}. In addition,
\code{stratum} variables are converted to dummy variables, and
natural cubic spline basis variables are created for the visit-specific
intercepts.
\item \code{fit_switch}: A list of fitted switching models for the
denominator and numerator by treatment group.
\item \code{data_outcome}: The input data for the outcome Cox model
including the inverse probability of censoring weights.
The variables include \code{id}, \code{stratum}, \code{"tstart"},
\code{"tstop"}, \code{"event"}, \code{"treated"}, \code{"crossed"},
\code{"unstablized_weight"}, \code{"stabilized_weight"},
\code{base_cov}, and \code{treat}.
If \code{treat_alt_interaction} is \code{TRUE},
the data set also includes the \code{"treated_crossed"} variable.
\item \code{weight_summary}: A data frame summarizing the weights by
treatment arm.
\item \code{km_outcome}: The Kaplan-Meier estimates of the survival
functions for the treatment and control groups based on the
weighted outcome data truncated at time of treatment switching.
\item \code{lr_outcome}: The log-rank test results for the treatment
effect based on the weighted outcome data truncated at time of
treatment switching.
\item \code{fit_outcome}: The fitted outcome Cox model.
\item \code{fail}: Whether a model fails to converge.
\item \code{settings}: A list containing the input parameter values.
\item \code{fail_boots}: The indicators for failed bootstrap samples
if \code{boot} is \code{TRUE}.
\item \code{fail_boots_data}: The data for failed bootstrap samples
if \code{boot} is \code{TRUE}.
\item \code{hr_boots}: The bootstrap hazard ratio estimates
if \code{boot} is \code{TRUE}.
}
}
\description{
Excludes data after treatment switching when fitting
the switching model to estimate the probabilities of not switching and
then switching. The inverse of these probabilities (inverse probability
of treatment weights) are then used as weights in a Cox model
including data after switching to estimate the adjusted hazard ratio.
}
\details{
The hazard ratio and confidence interval under a no-switching
scenario are obtained as follows:
\itemize{
\item Exclude observations after treatment switch when fitting the
switching model.
\item Define crossover indicators for the last time interval
of each subject.
\item Fit the denominator switching model (and numerator model for
stabilized weights) using a pooled logistic regression model to
estimate the inverse probability of treatment weights (IPTWs).
\itemize{
\item The probability of remaining unswitched is calculated as
\eqn{1 - \hat{p}_{\text{switch}}} and multiplied
over time before treatment switch.
\item At the time of switching, this product is multiplied by the
predicted probability of switching.
\item After treatment switch, the IPTW remains constant.
\item The inverse of the probability at the start of each interval
is used as the interval weight.
}
\item Fit a weighted Cox model to the outcome survival times, including
data after treatment switch, to estimate the hazard ratio.
\item Construct the p-value and confidence interval for the hazard ratio
using either robust sandwich variance or bootstrapping. When
bootstrapping is used, the confidence interval and p-value are
based on a t-distribution with \code{n_boot - 1} degrees of freedom.
}
}
\examples{

library(dplyr)

sim1 <- tssim(
  tdxo = 1, coxo = 1, allocation1 = 1, allocation2 = 1,
  p_X_1 = 0.3, p_X_0 = 0.3, 
  rate_T = 0.002, beta1 = -0.5, beta2 = 0.3, 
  gamma0 = 0.3, gamma1 = -0.9, gamma2 = 0.7, gamma3 = 1.1, gamma4 = -0.8,
  zeta0 = -3.5, zeta1 = 0.5, zeta2 = 0.2, zeta3 = -0.4, 
  alpha0 = 0.5, alpha1 = 0.5, alpha2 = 0.4, 
  theta1_1 = -0.4, theta1_0 = -0.4, theta2 = 0.2,
  rate_C = 0.0000855, accrualIntensity = 20/30,
  fixedFollowup = FALSE, plannedTime = 1350, days = 30,
  n = 500, NSim = 100, seed = 314159)

fit1 <- msm(
  sim1[[1]], id = "id", tstart = "tstart", 
  tstop = "tstop", event = "event", treat = "trtrand", 
  swtrt = "xo", swtrt_time = "xotime", 
  base_cov = "bprog", numerator = "bprog", 
  denominator = c("bprog", "L"), 
  ns_df = 3, swtrt_control_only = TRUE, boot = FALSE)
  
fit1

}
\references{
James M. Robins, Miguel Angel Hernan, and Babette Brumback.
Marginal structural models and causal inference in epidemiology.
Epidemiology. 2000;11(5):550-560.

Miguel Angel Hernan, Babette Brumback, and James M. Robins.
Marginal structural modesl to estimate the causual effect of zidovudine
on the survival of HIV-positive men. Epidemiology. 2000;11(5):561-570.

Jing Xu, Guohui Liu, and Bingxia Wang.
Bias and Type I error control in correcting treatment effect for
treatment switching using marginal structural models in Phase III
oncology trials.
Journal of Biopharmaceutical Statistics. 2022;32(6):897-914.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
